<?php
// Datubāzes konfigurācija
$servername = "localhost";
$username = "root";
$password = "";
$dbname = "quiz_db";

// Sāk vai atsāk sesiju
session_start();

// Pārbauda, vai lietotājs ir pierakstījies
if (!isset($_SESSION['user_id'])) {
    // Apreķina gadījumu, ja lietotājs nav pierakstījies (parāda kļūdas ziņojumu)
    die("Lietotājs nav pierakstījies");
}

// Iegūst lietotāja ID no sesijas
$user_id = $_SESSION['user_id'];

// Izveido savienojumu
$conn = new mysqli($servername, $username, $password, $dbname);

// Pārbauda savienojumu
if ($conn->connect_error) {
    die("Savienojums neizdevās: " . $conn->connect_error);
}

// Sagatavo SQL paziņojumu ar parametrizētu vaicājumu, lai novērstu SQL iebrukumus
$sql = "SELECT id, name FROM tests WHERE creator_id = ?";
$stmt = $conn->prepare($sql);

// Saista lietotāja ID parametru ar sagatavoto paziņojumu
$stmt->bind_param("i", $user_id);

// Izpilda sagatavoto paziņojumu
$stmt->execute();

// Iegūst rezultātu kopa no izpildītā paziņojuma
$result = $stmt->get_result();

$tests = [];

// Izgūst katru rindiņu no rezultātu kopas
while ($row = $result->fetch_assoc()) {
    // Saglabā testa ID un nosaukumu asociatīvā masīvā
    $test = [
        "id" => $row["id"],
        "name" => $row["name"]
    ];
    // Pievieno testu masīvam ar testiem
    $tests[] = $test;
}

// Aizver sagatavoto paziņojumu
$stmt->close();

// Aizver datubāzes savienojumu
$conn->close();

// Iestata atbildes galvenes, lai norādītu JSON saturu
header('Content-Type: application/json');

// Izvada testu masīvu kā JSON
echo json_encode($tests);
?>
